/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.network;

import com.alexander.mutantmore.entities.Rodling;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SyncRodlingCheckerUpdatesToServerPacket {
    private final boolean burnBlocks;
    private final boolean alwaysShowName;
    private final int targetRodlingID;

    public SyncRodlingCheckerUpdatesToServerPacket(Rodling rodling, boolean burnBlocks, boolean alwaysShowName) {
        this.targetRodlingID = rodling.m_19879_();
        this.burnBlocks = burnBlocks;
        this.alwaysShowName = alwaysShowName;
    }

    public SyncRodlingCheckerUpdatesToServerPacket(FriendlyByteBuf buf) {
        this.targetRodlingID = buf.readInt();
        this.burnBlocks = buf.readBoolean();
        this.alwaysShowName = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.targetRodlingID);
        buf.writeBoolean(this.burnBlocks);
        buf.writeBoolean(this.alwaysShowName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            Entity rodling = player.f_19853_.m_6815_(this.targetRodlingID);
            if (rodling instanceof Rodling) {
                ((Rodling)rodling).setBurnsBlocks(this.burnBlocks);
                ((Rodling)rodling).setAlwaysShowsName(this.alwaysShowName);
            }
        });
        return true;
    }
}

